<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Table extends Model 
{

    protected $table = 'tables';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ceremonie_id', 'slug', 'numero', 'nom', 'statut');
    protected $visible = array('ceremonie_id', 'slug', 'numero', 'nom', 'statut');

    public function invitesTables()
    {
        return $this->hasMany('App\Models\InviteTable', 'table_id');
    }

    public function ceremonie()
    {
        return $this->belongsTo('App\Models\Ceremonie', 'ceremonie_id');
    }

}